--DROP PROCEDURE App.NVCC_usp_UniqueVeterans

USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE App.NVCC_usp_UniqueVeterans

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UniqueVeterans
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 11-02-2016
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get aggregated counts of RDPs and unique veterans at
--                        station and VISN levels of aggregation
--==================================================================================

BEGIN
	SELECT 
		PatientIEN, p.Sta3n, VISNFY17 
	INTO #TMP
	FROM 
		App.vNVCC_ProductionAccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
		INNER JOIN CDWWork.Dim.Sta3n s
			ON p.Sta3n = s.Sta3n

	SELECT
		ROW_NUMBER() OVER (ORDER BY VISNFY17, Sta3n) AS ID,
		VISNFY17,
		App.udf_StationName(Sta3n) AS Station,
		RDP,
		UniqueVeterans
	FROM (
		SELECT
			VISNFY17,
			Sta3n,
			count(*) AS RDP,
			count(distinct PatientIEN) AS UniqueVeterans
		FROM #TMP
		GROUP BY Sta3n, VISNFY17
		UNION
		SELECT
			VISNFY17,
			NULL AS Sta3n,
			count(*) AS RDP,
			count(distinct PatientIEN) AS UniqueVeterans
		FROM #TMP
		GROUP BY VISNFY17
		UNION
		SELECT
			NULL AS VISNFY17,
			NULL AS Sta3n, 
			count(*) AS RDP,
			count(distinct PatientIEN) AS UniqueVeterans
		FROM #TMP
	) A
	ORDER BY VISNFY17, Sta3n

	DROP TABLE #TMP
END
GO

EXEC dbo.sp_SignAppObject 'NVCC_usp_UniqueVeterans';